#include <bits/stdc++.h>
using namespace std;

bool isPrefix(const string &a, const string &b) {
    if (a.size() > b.size()) return false;
    return b.substr(0, a.size()) == a;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<string> a(n);
    for (int i = 0; i < n; i++) cin >> a[i];

    sort(a.begin(), a.end());

    vector<vector<string>> groups;

    for (int i = 0; i < n; i++) {
        bool placed = false;
        for (auto &g : groups) {
            bool ok = true;
            for (auto &x : g) {
                if (!isPrefix(x, a[i]) && !isPrefix(a[i], x)) {
                    ok = false;
                    break;
                }
            }
            if (ok) {
                g.push_back(a[i]);
                placed = true;
                break;
            }
        }
        if (!placed) groups.push_back({a[i]});
    }

    cout << groups.size() << "\n";
    for (auto &g : groups) {
        cout << g.size() << "\n";
        for (auto &x : g) cout << x << " ";
        cout << "\n";
    }
    return 0;
}
